#include <bits/stdc++.h>
using namespace std;

struct Mast {
    long long x, h;
    int idx;
    
    bool operator<(const Mast& other) const {
        return x < other.x;
    }
};

struct Point {
    long long x, y;
};

const long long INFLL = (1LL << 60);
const double INF = 1e18;

inline double sqr(double x) { return x * x; }

inline double dist2(double x1, double y1, double x2, double y2) {
    return sqr(x1 - x2) + sqr(y1 - y2);
}

inline double dist(double x1, double y1, double x2, double y2) {
    return sqrt(dist2(x1, y1, x2, y2));
}

// ???????? ?? ???????? ?????????? ?? ??????
double ropeDistance(const Mast& m, const Mast& m1, const Mast& m2) {
    long long x = m.x, h = m.h;
    long long x1 = m1.x, h1 = m1.h;
    long long x2 = m2.x, h2 = m2.h;
    
    // ??? ?? ?????? ???? ?? ??? ????? ??????
    if (h > max(h1, h2)) return INF;
    
    // ????????? ????? ???????
    double x0 = (h1 + x1 - h2 + x2) / 2.0;
    double y0 = -x0 + (h1 + x1);
    
    double minDist = INF;
    
    // 1. ??????? ??? (????? ???????)
    if (y0 >= h) {
        minDist = min(minDist, dist(x, h, x0, y0));
    }
    
    // 2. ???? ?????? ?????? (????? -1): y = -x + (h1 + x1)
    if (h1 >= h) {
        // ??????? ????? ??? ?? y = h
        double x_left = h1 + x1 - h;
        if (x1 <= x_left && x_left <= x0) {
            minDist = min(minDist, fabs(x - x_left));
        }
    }
    
    // 3. ????? ?????? ?????? (????? +1): y = x + (h2 - x2)
    if (h2 >= h) {
        // ??????? ????? ??? ?? y = h
        double x_right = h + x2 - h2;
        if (x0 <= x_right && x_right <= x2) {
            minDist = min(minDist, fabs(x - x_right));
        }
    }
    
    return minDist;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n;
    if (!(cin >> n)) return 0;
    
    vector<long long> xs(n), hs(n);
    for (int i = 0; i < n; i++) cin >> xs[i];
    for (int i = 0; i < n; i++) cin >> hs[i];
    
    vector<Mast> masts(n);
    for (int i = 0; i < n; i++) {
        masts[i] = {xs[i], hs[i], i};
    }
    
    // ???????? ?? x
    sort(masts.begin(), masts.end());
    
    // ????? ??????? ??????????
    vector<double> best(n, INF);
    
    // === ???? 1: ???????? ?? ????????? ===
    // ????????? ???? ???????? ??????? ???????? ?? x
    // ?????????? ??????? ?? ?????? (?? ???????? ????? ????????)
    
    vector<int> order(n);
    iota(order.begin(), order.end(), 0);
    sort(order.begin(), order.end(), [&](int a, int b) {
        return hs[a] > hs[b];
    });
    
    set<pair<long long, int>> active; // (x, idx)
    
    for (int idx : order) {
        long long x_i = xs[idx];
        long long h_i = hs[idx];
        
        // ??????????? ???????? ? ???????? ?????????
        auto it = active.lower_bound({x_i, -1});
        
        // ??????? ?????? ?????? (??????????: ???? 12 ?????????)
        const int RANGE = 12;
        int count = 0;
        
        // ?????
        for (auto it2 = it; it2 != active.end() && count < RANGE; ++it2) {
            int j = it2->second;
            if (i == j) continue;
            double d2 = dist2(x_i, h_i, xs[j], hs[j]);
            double d = sqrt(d2);
            if (d < best[idx]) best[idx] = d;
            count++;
        }
        
        // ????
        count = 0;
        for (auto it2 = it; it2 != active.begin() && count < RANGE; ) {
            --it2;
            int j = it2->second;
            if (i == j) continue;
            double d2 = dist2(x_i, h_i, xs[j], hs[j]);
            double d = sqrt(d2);
            if (d < best[idx]) best[idx] = d;
            count++;
        }
        
        // ????? ???? ?????? ? ???????
        active.insert({x_i, idx});
    }
    
    // === ???? 2: ???????? ?? ???????? ===
    // ?? ????? ?????, ??????? ???? ??????? ???????
    for (int i = 0; i < n-1; i++) {
        const Mast& m1 = masts[i];
        const Mast& m2 = masts[i+1];
        
        // ??????????? ????? ??????? ?? ???????
        long long range = max(1000LL, llabs(m2.x - m1.x) / 2);
        long long left = min(m1.x, m2.x) - range;
        long long right = max(m1.x, m2.x) + range;
        
        // ??????? ???????? ?? ???????
        int l = lower_bound(masts.begin(), masts.end(), left, 
                           [](const Mast& m, long long val) { return m.x < val; }) - masts.begin();
        int r = upper_bound(masts.begin(), masts.end(), right, 
                           [](long long val, const Mast& m) { return val < m.x; }) - masts.begin();
        
        // ??????? ??? ??????? ? ??????
        for (int j = l; j < r; j++) {
            const Mast& m = masts[j];
            double d = ropeDistance(m, m1, m2);
            if (d < best[m.idx]) best[m.idx] = d;
        }
    }
    
    // === ????? ===
    cout.setf(ios::fixed);
    cout << setprecision(0);
    
    for (int i = 0; i < n; i++) {
        if (best[i] >= INF/2) {
            cout << "-1\n";
        } else {
            // ???????? ?? ???????? ??? ????
            long long ans = (long long) round(best[i]);
            cout << ans << "\n";
        }
    }
    
    return 0;
}